
if ~exist('avgPSAPtime','var')
	AAE_QualityControl();
end

if ~exist('conctime','var')
	hiscale_averagingAerosolConc();
end

hfig = figure;
set(hfig,'Units','normalized','Position',[0.1,0.1,0.8,0.8]);
hax = tight_subplot(2,1,[0,0.1],[0.1,0.1],[0.1,0.1]);

IOPchoice = 1; %this should be either 1 or 2 depending on the IOP you want to display
lw = 2;

if IOPchoice == 1
    for i = 1:length(hax)
        
        if i == 1
            axes(hax(i));
            plot(avgPSAPtime,redfilt,'r-','LineWidth',lw);
			hold on;
			plot(avgPSAPtime,bluefilt,'b-','LineWidth',lw);
			plot(avgPSAPtime,greenfilt,'g-','LineWidth',lw);
            
			if size(hax,1) == 2
				annotation('textbox',[0.855,0.81,0.1,0.1],'FitBoxToText','on','String','a)','LineStyle','none','FontSize',20,'FontWeight','bold');
			elseif size(hax,1) == 3
				annotation('textbox',[0.855,0.61,0.1,0.1],'FitBoxToText','on','String','b)','LineStyle','none','FontSize',20,'FontWeight','bold');
			end
			
            %         v = axis;
            %         handle=title('Red Absorption Coefficient');
            %         set(handle,'Position',[v(1)*1.2 v(4)*.8 0]);
            %         xlabel('Time (days)','FontSize',30)% x-axis label
                    
            ylim([0,30]);
			xlim([datetime(datevec('04-26-2016 00:00:00')),datetime(datevec('05-19-2016 00:00:00'))]);
            set(gca,'FontSize',15,'YTick',[10,20,30],'Color','none');
			
			if i == size(hax,1)
				hax(i).XTick = [...
					datetime(datevec('04-26-2016 00:00:00')),...
					datetime(datevec('04-28-2016 00:00:00')),...
					datetime(datevec('04-30-2016 00:00:00')),...
					datetime(datevec('05-02-2016 00:00:00')),...
					datetime(datevec('05-04-2016 00:00:00')),...
					datetime(datevec('05-06-2016 00:00:00')),...
					datetime(datevec('05-08-2016 00:00:00')),...
					datetime(datevec('05-10-2016 00:00:00')),...
					datetime(datevec('05-12-2016 00:00:00')),...
					datetime(datevec('05-14-2016 00:00:00')),...
					datetime(datevec('05-16-2016 00:00:00')),...
					datetime(datevec('05-18-2016 00:00:00'))];
			else
				set(gca,'XTickLabel',[],'XTick',[]);
			end
			ylabel('\sigma_{PSAP} (Mm^{-1})','FontSize',30,'FontWeight','bold') % y-axis label

            
        elseif i == 2
            axes(hax(i));
% 			area(conctime,conc./10,'FaceColor',[0.5,0.5,0.8],'EdgeColor',[0.3,0.3,0.6],'FaceAlpha',0.3,'LineWidth',1);
            plot(conctime,conc./10,'LineWidth',1);
			hold on;
			plot(cotime,co.*1700,'k-','LineWidth',2);
			
			
			annotation('textbox',[0.855,0.41,0.1,0.1],'FitBoxToText','on','String','c)','LineStyle','none','FontSize',20,'FontWeight','bold'); %This is for 2 plots
%             annotation('textbox',[0.855,0.21,0.1,0.1],'FitBoxToText','on','String','a)','LineStyle','none','FontSize',20,'FontWeight','bold');
            %     ylim([0,0.0015]);
            %         dynamicDateTicks;
            %         zoomAdaptiveDateTicks('on');
            %         title('Blue absorption coefficient','FontSize',30)
            %         xlabel('Time (days)','FontSize',30)% x-axis label
            %         ylabel('Absorbance (1/Mm)','FontSize',30) % y-axis label
            ylim([0,2500]);

            xlim([datetime([2016,04,26,00,30,00]),datetime([2016,05,19,23,59,00])]);  %datevec('04-26-2016 00:30:00') datevec('05-19-2016 23:59:00')
            set(gca,'FontSize',15,'Color','none');
			
% 			ylabel('CO (ppb)','FontSize',20,'FontWeight','bold');  %%For CO
% 			set(gca,'YTick',[0,500,1000,1500].*1.66,'YTickLabel',{'0','500','1000','1500'});  %% For CO
			
			xlim([datetime(datevec('04-26-2016 00:00:00')),datetime(datevec('05-19-2016 00:00:00'))]);
			if i == size(hax,1)
				hax(i).XTick = [...
					datetime(datevec('04-26-2016 00:00:00')),...
					datetime(datevec('04-28-2016 00:00:00')),...
					datetime(datevec('04-30-2016 00:00:00')),...
					datetime(datevec('05-02-2016 00:00:00')),...
					datetime(datevec('05-04-2016 00:00:00')),...
					datetime(datevec('05-06-2016 00:00:00')),...
					datetime(datevec('05-08-2016 00:00:00')),...
					datetime(datevec('05-10-2016 00:00:00')),...
					datetime(datevec('05-12-2016 00:00:00')),...
					datetime(datevec('05-14-2016 00:00:00')),...
					datetime(datevec('05-16-2016 00:00:00')),...
					datetime(datevec('05-18-2016 00:00:00'))];
			else
				set(gca,'XTickLabel',[],'XTick',[]);
			end
			ylabel('Particle Conc. x10^4 (cm^{-3})','FontSize',20,'FontWeight','bold','Color',[0,0.447,0.741]);
			set(gca,'YTick',[0,500,1000,1500,2000,2500],'YTickLabel',{'0','0.5','1','1.5','2','2.5'},'YColor',[0,0.447,0.741]);
            
        elseif i==3
            axes(hax(i));
            plot(avgPSAPtime,angrbfilt,'-','LineWidth',lw,'Color',[0.8,0,0.8]);
			hold on;
% 			plot(avgPSAPtime,angrbfilt + err_ang,'-','LineWidth',lw-1.5,'Color',[0.5,0.5,0.5]);
% 			plot(avgPSAPtime,angrbfilt - err_ang,'-','LineWidth',lw-1.5,'Color',[0.5,0.5,0.5]);
			
%             annotation('textbox',[0.855,0.275,0.1,0.1],'FitBoxToText','on','String','c)','LineStyle','none','FontSize',20,'FontWeight','bold'); %This is for 3 plots
%             
			annotation('textbox',[0.855,0.41,0.1,0.1],'FitBoxToText','on','String','b)','LineStyle','none','FontSize',20,'FontWeight','bold'); %This is for 2 plots
			
            ylim([0.2,2.8]);
            xlim([datetime(datevec('04-26-2016 00:00:00')),datetime(datevec('05-19-2016 00:00:00'))]);
            
			
			set(gca,'FontSize',15,'YTick',[-2,-1,0,1,2,3],'Color','none');
			
			if i == size(hax,1)
				setxlims(i);
			else
				set(gca,'XTickLabel',[],'XTick',[]);
			end
			
			ylabel('Red/Blue AAE','FontSize',30,'FontWeight','bold') % y-axis label
            
            
            %         ymin = min(ylimits);
            %         ymax = max(ylimits);
            
            
        end
        
        %     dynamicDateTicks;
        
        
        
        
    end
elseif IOPchoice == 2
    for i = 1:length(hax)
        
        if i == 1
            axes(hax(i));
            plot(datenum(datevec(hourlytime)),avgRPSAP,'r-','LineWidth',1.5);
            %         dynamicDateTicks;
            %     ylim([0,0.0015]);
            
            %         zoomAdaptiveDateTicks('on');
            %         title('Red Absorption Coefficient','FontSize',30);%,'Position',[xstart,ystart,width,height])
            
            annotation('textbox',[0.855,0.81,0.1,0.1],'FitBoxToText','on','String','a)','LineStyle','none','FontSize',20,'FontWeight','bold');
            %         v = axis;
            %         handle=title('Red Absorption Coefficient');
            %         set(handle,'Position',[v(1)*1.2 v(4)*.8 0]);
            %         xlabel('Time (days)','FontSize',30)% x-axis label
            %         ylabel('Absorbance (1/Mm)','FontSize',30) % y-axis label
            ylim([0,20]);
            xlim([datenum(datevec('08-25-2016 00:30:00')),datenum(datevec('09-22-2016 23:59:00'))]);
            %         ylimits = get(gca,'YLim');
            set(gca,'FontSize',15,'XTickLabel',[],'XTick',[],'YTick',[5,10,15,20]);%,'XColor','none');
            %         ymin = min(ylimits);
            %         ymax = max(ylimits);
            
        elseif i ==2
            axes(hax(i));
            plot(datenum(datevec(hourlytime)),avgBPSAP,'b-','LineWidth',1.5);
            annotation('textbox',[0.855,0.54,0.1,0.1],'FitBoxToText','on','String','b)','LineStyle','none','FontSize',20,'FontWeight','bold');
            %     ylim([0,0.0015]);
            %         dynamicDateTicks;
            %         zoomAdaptiveDateTicks('on');
            %         title('Blue absorption coefficient','FontSize',30)
            %         xlabel('Time (days)','FontSize',30)% x-axis label
            %         ylabel('Absorbance (1/Mm)','FontSize',30) % y-axis label
            ylim([0,45]);
            xlim([datenum(datevec('08-25-2016 00:30:00')),datenum(datevec('09-22-2016 23:59:00'))]);  %datevec('04-26-2016 00:30:00') datevec('05-19-2016 23:59:00')
            %         ylimits = get(gca,'YLim');
            set(gca,'FontSize',15,'XTickLabel',[],'XTick',[],'YTick',[10,20,30,40]);%,'XColor','none');
            %         ymin = min(ylimits);
            %         ymax = max(ylimits);
            
        elseif i==3
            axes(hax(i));
            plot((datenum(datevec(hourlytime))),rbavgAng,'-','LineWidth',1.5,'Color',[0.8,0,0.8]);
            annotation('textbox',[0.855,0.275,0.1,0.1],'FitBoxToText','on','String','c)','LineStyle','none','FontSize',20,'FontWeight','bold');
            ylim([-1,3]);
            
            %         xlim([datenum(datevec('04-26-2016 00:30:00')),datenum(datevec('05-18-2016 00:00:00'))]);
%             hax(i).XTick = [...
%                 datenum(datevec('04-26-2016 00:00:00')),...
%                 datenum(datevec('04-29-2016 00:00:00')),...
%                 datenum(datevec('05-02-2016 00:00:00')),...
%                 datenum(datevec('05-05-2016 00:00:00')),...
%                 datenum(datevec('05-08-2016 00:00:00')),...
%                 datenum(datevec('05-11-2016 00:00:00')),...
%                 datenum(datevec('05-14-2016 00:00:00')),...
%                 datenum(datevec('05-17-2016 00:00:00'))];
            %         zoomAdaptiveDateTicks('on');
            % %         title('AVG Red:Blue Angstrom Exponent','FontSize',30)
            %         xlabel('Time','FontSize',30) % x-axis label
            %         ylabel('Red/Blue Absorbance','FontSize',30) % y-axis label
            
            set(gca,'FontSize',15,'YTick',[-2,-1,0,1,2,3]);
            %         ymin = min(ylimits);
            %         ymax = max(ylimits);
            
            
        end
        
        %     dynamicDateTicks;
        xlim([datenum(datevec('08-25-2016 00:30:00')),datenum(datevec('09-22-2016 23:59:00'))]);
        
        
        
    end
end


if IOPchoice == 1
    for j = 1:length(hax)
        axes(hax(j));
		hiscale_addrainpatch();
		
		
    end
elseif IOPchoice == 2
    for j = 1:length(hax)
        
        
        IOP2startdates_sampling = datenum([...
            '08/25/2016 13:50:00'
            '08/26/2016 09:50:00'
            '08/27/2016 11:20:00'
            '08/28/2016 11:00:00'
            '08/29/2016 11:00:00'
            '08/30/2016 10:30:00'
            '08/31/2016 12:00:00'
            '09/01/2016 14:00:00'
            '09/02/2016 12:00:00'
            '09/03/2016 10:00:00'
            '09/04/2016 10:17:00'
            '09/05/2016 10:00:00'
            '09/06/2016 10:00:00'
            '09/07/2016 10:00:00'
            '09/09/2016 10:00:00'
            '09/10/2016 10:00:00'
            '09/11/2016 10:00:00'
            '09/12/2016 10:00:00'
            '09/13/2016 10:00:00'
            '09/14/2016 10:00:00'
            '09/15/2016 10:00:00'
            '09/16/2016 14:00:00'
            '09/17/2016 10:00:00'
            '09/18/2016 10:00:00'
            '09/19/2016 10:00:00'
            '09/20/2016 10:00:00'
            '09/21/2016 10:00:00'
            '09/22/2016 10:00:00']);
        
        IOP2enddates_sampling = datenum([...
            '08/25/2016 16:00:00'
            '08/26/2016 13:20:00'
            '08/27/2016 16:20:00'
            '08/28/2016 14:30:00'
            '08/29/2016 15:20:00'
            '08/30/2016 15:30:00'
            '08/31/2016 16:30:00'
            '09/01/2016 17:45:00'
            '09/02/2016 17:30:00'
            '09/03/2016 16:30:00'
            '09/04/2016 18:30:00'
            '09/05/2016 16:30:00'
            '09/06/2016 16:30:00'
            '09/07/2016 11:30:00'
            '09/09/2016 16:30:00'
            '09/10/2016 16:30:00'
            '09/11/2016 16:30:00'
            '09/12/2016 14:30:00'
            '09/13/2016 14:30:00'
            '09/14/2016 16:30:00'
            '09/15/2016 16:30:00'
            '09/16/2016 20:30:00'
            '09/17/2016 16:30:00'
            '09/18/2016 16:30:00'
            '09/19/2016 16:30:00'
            '09/20/2016 16:30:00'
            '09/21/2016 16:30:00'
            '09/22/2016 16:30:00']);
        
        IOP2startdates_rain = datenum([...
            '08/29/2016 16:00:00'
            '08/29/2016 14:00:00'
            '09/01/2016 06:00:00'
            '09/07/2016 12:00:00'
            '09/08/2016 08:00:00'
            '09/09/2016 22:00:00'
            '09/13/2016 15:00:00'
            '09/16/2016 06:00:00']);
            
         IOP2enddates_rain = datenum([...
            '08/29/2016 20:00:00'
            '08/29/2016 15:00:00';
            '09/01/2016 13:00:00';
            '09/07/2016 20:00:00';
            '09/08/2016 19:00:00';
            '09/10/2016 01:00:00'
            '09/13/2016 22:00:00';
            '09/16/2016 14:00:00']);
            
            
        
        
        axes(hax(j));
        hold on;
        ylimits = get(gca,'YLim');
        ymin = min(ylimits);
        ymax = max(ylimits);
        
        % Rain Events
        for g = 1:length(IOP2enddates_rain)
            patchx = [IOP2startdates_rain(g), IOP2startdates_rain(g), IOP2enddates_rain(g), IOP2enddates_rain(g)];
            patchy = [ymin ymax ymax ymin];
            fill(patchx,patchy,'red','FaceAlpha',0.2,'EdgeAlpha',0);
        end
        
        % sampling dates:
        for q = 1:length(IOP2startdates_sampling)
            patchx =  [IOP2startdates_sampling(q), IOP2startdates_sampling(q), IOP2enddates_sampling(q), IOP2enddates_sampling(q)];
            patchy = [ymin ymax ymax ymin];
            fill(patchx,patchy,'black','FaceAlpha',0.2,'EdgeAlpha',0);
        end
    end
end


savetest = 0;

if savetest == 1
    export_fig('3figure_AGU17_Absorption','-png','-transparent');
end

function setxlims(i)
% xlabel('Time','FontSize',30,'FontWeight','bold') % x-axis label
hax(i).XTick = [...
	datetime(datevec('04-26-2016 00:00:00')),...
	datetime(datevec('04-28-2016 00:00:00')),...
	datetime(datevec('04-30-2016 00:00:00')),...
	datetime(datevec('05-02-2016 00:00:00')),...
	datetime(datevec('05-04-2016 00:00:00')),...
	datetime(datevec('05-06-2016 00:00:00')),...
	datetime(datevec('05-08-2016 00:00:00')),...
	datetime(datevec('05-10-2016 00:00:00')),...
	datetime(datevec('05-12-2016 00:00:00')),...
	datetime(datevec('05-14-2016 00:00:00')),...
	datetime(datevec('05-16-2016 00:00:00'))];
end

% ASOP = [3,1,3,23,25,9,13,15,12,70,60,10,35]
% AngExp = [0.808,0.808,0.706,1.196,1.419,1.419,1.2256,1.2256,1.148,2.0124,2.1024,1.2897,1.2897]
%
% mdl = fitlm(ASOP,AngExp);
%
% figure;
% scatterplot(ASOP,AngExp);


% 
% rain = ncread('sgpaosmetE13.a1.20170908.000000.nc','rain_intensity')
% 
% % ncdisp('sgpmetE13.b1.20160908.000000.cdf')
% 
% if rain > 0
%     disp('there is at least one value above the limit')
% else
%     disp('All values are below the limit.')
% end

